# BEGIN SourceDeps(oneline):
BuildRequires: fontconfig-devel libX11-devel libXpm-devel libfreetype-devel libgd2-devel libjpeg-devel libpng-devel libtiff-devel libwebp-devel perl(Config.pm) perl(DynaLoader.pm) perl(ExtUtils/MakeMaker.pm) perl(GD.pm) perl(Test.pm)
# END SourceDeps(oneline)
%define module_version 0.25
%define module_name GD-Image-CopyIFS
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.25
Release: alt7
Summary: fractal-based image copying and resizing
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RK/RKOBES/%module_name-%module_version.tar.gz

%description
This module adds to the `GD::Image' module of `GD'
two methods: `copyIFS', used to copy and resize an area of
one image onto another image, and `thumbIFS', used to
create a rescaled image from an original. The `copyIFS'
method is used analagously to the `copyResized' or
`copyResampled' methods of the `GD' module.

The algorithm employed uses what is known as a fractal
interpolating function, which uses an Iterated Function
System (IFS) to interpolate functions specified at
discrete points. The basic procedure is to create an
IFS based on the pixel colors of an image, and then
from this construct a new IFS based on the parameters
specified when rescaling an area of the image.
A random iteration algorithm is then used
to construct an image from this new IFS. For details, see
http://ecommons.uwinnipeg.ca/archive/00000026/.

Note that this algorithm may give good results for images
of natural objects, as there is generally a fractal
nature present in most such shapes. It typically
will not give good results for more geometric shapes,
such as lettering.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_archlib/G*
%perl_vendor_autolib/*

%changelog
