# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(IO/Handle.pm) perl(Module/Build.pm) perl(Scalar/Util.pm) perl(base.pm) perl(subs.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    GPS-Babel
%define upstream_version 0.11

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Perl interface to gpsbabel
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module//%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(File/Which.pm)
BuildRequires: perl(Geo/Gpx.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Requires: gpsbabel
Source44: import.info

%description
From the http://gpsbabel.org/ manpage:

    GPSBabel converts waypoints, tracks, and routes from one format to
    another, whether that format is a common mapping format like
    Delorme, Streets and Trips, or even a serial upload or download to a
    GPS unit such as those from Garmin and Magellan. By flattening the
    Tower of Babel that the authors of various programs for manipulating
    GPS data have imposed upon us, it returns to us the ability to
    freely move our own waypoint data between the programs and hardware
    we choose to use.

GPSBabel supports 96 various GPS related data formats. In addition to file
conversion it supports upload and download to a number of serial and USB
devices. This module provides a (thin) wrapper around the gpsbabel binary
making it easier to use in a perlish way.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.yml README SIGNATURE
%perl_vendor_privlib/*



%changelog
