# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(GRID/Machine.pm) perl(GRID/Machine/MakeAccessors.pm) perl(GRID/Machine/Message.pm) perl(GRID/Machine/Result.pm) perl(IO/Select.pm) perl(List/Util.pm) perl(Parallel/ForkManager.pm) perl(Pod/Usage.pm) perl(Scalar/Util.pm) perl(Term/Prompt.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name GRID-Cluster
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt5
Summary: Virtual clusters using SSH links
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/E/ED/EDUSEGRE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module is based on the module the GRID::Machine manpage. It provides a set
of methods to create 'virtual' clusters by the use of SSH links for
communications among different remote hosts.

Since main features of `GRID::Machine' are zero administration and minimal
installation, the GRID::Cluster manpage directly inherites these features.

Mainly, `GRID::Cluster' provides:

=over

=item *

An extension of the Perl `qx' method. Instead of a single command it receives a 
list of commands. Commands are executed - via SSH - using the master-worker paradigm.

=item *

Services for the transference of files among machines.

=back

%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/G*

%changelog
