%define module_name Game-Life-Faster
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Meta.pm) perl(Carp.pm) perl(Data/Dump.pm) perl(Game/Life.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Module/Metadata.pm) perl(Pod/Usage.pm) perl(Term/Cap.pm) perl(Term/ReadLine.pm) perl(Test2/Plugin/BailOnFail.pm) perl(Test2/Tools/LoadModule.pm) perl(Test2/V0.pm) perl(constant.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.007
Release: alt1
Summary: Play John Horton Conway's Game of Life, hopefully faster than a naive implementation.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WY/WYANT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This Perl package is yet another implementation of John Horton Conway's
Game of Life. This "game" takes place on a rectangular grid, each of
whose cells is considered "living" or "dead". The grid is seeded with an
initial population, and then the rules are iterated. In each iteration
cells change state based on their current state and how many of the 8
adjacent cells (orthogonally or diagonally) are "living".

In Conway's original formulation, the rules were that a "dead" cell
becomes alive if it has exactly two living neighbors, and a "living"
cell becomes "dead" unless it has two or three living neighbors.

This implementation was inspired by Game::Life, and is
intended to be reasonably compatible with its API. But the internals
have been tweaked in a number of ways in order to get better
performance, particularly on large but mostly-empty grids.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING Changes README
%perl_vendor_privlib/G*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
