# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(DB_File.pm) perl(English.pm) perl(ExtUtils/MakeMaker.pm) perl(Games/Go/GTP.pm) perl(Games/Go/Referee.pm) perl(HTML/TokeParser.pm) perl(IO/File.pm) perl(IO/Handle.pm) perl(IPC/Open2.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.07
%define module_name Games-Go-Player
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: plays a game of Go.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DE/DEG/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This program generates a move on a Go board according to patterns 
that it learns from game records in SGF.

It puts patterns into a database (called pattern<colour><size>).
Which databases are updated depends on $self->{_veclengths}.
Pattern information is stored in a hash, where the key is the pattern,
(compressed using vec) and the value contains a score for each point
on the pattern from 0 to 255.
A pattern point is either empty, black, white, or 'not on the board'

For an example script that instructs Player to learn from a particular
directory, see pluserdir.pl in the scripts folder.

To play a move:

  my $move = $player->chooselegalmove($colour, $referee);
  $referee->play($colour, $move);
  $player->update($colour, $referee);

Or see kgspot.pl which is included in the scripts folder.

Before learning, the following parts of the 'new' method can (and 
in some cases, should) be edited:

$self->{_maxmove} For example, its probably not worth looking beyond move 10 when matching
whole board 19x19 games.

$self->{_weakest} For example, if matching patterns from a 9 handicap game between a 3 kyu
and a 12 kyu, you may want to disregard the moves of the 12kyu

The function loadratings can be tweaked as you see fit. For example, at the moment it gives
a higher score to a move close to the centre of a pattern than one on the edge.

%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/G*

%changelog
