%define module_name Games-Literati
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(IO/String.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.042
Release: alt1
Summary: - Literati resolver
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PETERCJ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Games::Literati helps you find out ALL solutions for a given
board and tiles.  Similarly it can be used to play Scrabble. 

The documentation of standalone functions will be added.

To used it to play the games:

_use Games::Literati;

_literati(min_tiles, max_tiles);

enter the data prompted then the best 10 solution will be displayed.

_literati(3,7);
_literati();      # use 1-7 tiles.
_scrabble();

It is recommended to pre-write everything into a file. and run the 
program via command-line.

In the file, the first 1-15 lines represent board situation, followed 
with "yes", followed by wild tile positions, if none, place a empty 
line here, then followed by tiles (can be less than 7), use ? to 
represent wild tiles. 

<B>make sure to put `wordlist' in the working directory when running.
the program.

For example, the file is named `t':

    ...............
    ...............
    ...............
    .......c.......
    ......ai.......
    .......s.header
    .......t....r..
    ...jurors..soup
    .......o....p.h
    .upsilon.f..pea
    .......speering
    .........s..n.e
    .........t..g..
    .........e
    ........broils
    yes
    7,8 10,14 7,14
    eurmsss
    <file end with a CR>

    from the command line:

    perl -e'use Games::Literati qw(literati); literati()' < t

    [....] 
    using 7 tiles:
    using 6 tiles:
    (9)     row 3 become: 'cussers' starting at column 8
    (9)     row 12 become: 'russets' starting at column 4
    using 5 tiles:
    (8)     row 3 become: 'cruses' starting at column 8
    (8)     row 3 become: 'curses' starting at column 8

    [...]

     Possible Ten Best Solution 1: column 3 become: 
     'susses' starting at row 10  using 5 tile(s), score 24
     Possible Ten Best Solution 2: column 3 become: 'serums' 
     starting at row 10  using 5 tile(s), score 24
     Possible Ten Best Solution 3: column 14 become: 'muser' 
     starting at row 1  using 4 tile(s), score 15
    [...]

    or

    perl -e'use Games::Literati qw(scrabble); scrabble()' < t

    [...]
    Possible Ten Best Solution 1: row 14 become: 'embroils' 
    starting at column 6  using 2 tile(s), score 36
    Possible Ten Best Solution 2: column 2 become: 'spumes' 
    starting at row 8  using 5 tile(s), score 22
    [...]


    Example 2:

    From beginning of the game, create file 't' like this:
    ...............
    ...............
    ...............
    ...............
    ...............
    ...............
    ...............
    ...............
    ...............
    ...............
    ...............
    ...............
    ...............
    ...............
    ...............
    yes
   
    ?omment


    $perl -e'use Games::Literati qw(literati); literati()' < t

    [...]
    using 7 tiles:
    (47)    row 7 become: 'comment' starting at column 1 (BINGO!!!!)
    (47)    row 7 become: 'memento' starting at column 1 (BINGO!!!!)
    (47)    row 7 become: 'metonym' starting at column 1 (BINGO!!!!)
    (47)    row 7 become: 'momenta' starting at column 1 (BINGO!!!!)
    (47)    row 7 become: 'momento' starting at column 1 (BINGO!!!!)
    [...]
    

    $ perl -e'use Games::Literati qw(scrabble);scrabble()' < t
    
    [...]
    (76)    row 7 become: 'comment' starting at column 1 (BINGO!!!!)
    (76)    row 7 become: 'memento' starting at column 1 (BINGO!!!!)
    (72)    row 7 become: 'metonym' starting at column 1 (BINGO!!!!)
    [...]

    good luck!:)

    

%prep
%setup -q -n %{module_name}-%{version}
# depth is > 1 .. moving up
#pushd "Literati"
#  mv -f * ../
#  mv -f .* ../ ||:
#popd

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE RELEASE.md README.md CHANGES
%perl_vendor_privlib/G*

%changelog
