# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(File/Find/Object.pm) perl(IO/All.pm) perl(PPI.pm) perl(Test/Run/CmdLine/Iface.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Games-Solitaire-Verify
%define upstream_version 0.2500

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Process and verify solitaire games
License:    MIT
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Games/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Class/XSAccessor.pm)
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(Dir/Manifest.pm)
BuildRequires: perl(Exception/Class.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(POSIX.pm)
BuildRequires: perl(Path/Tiny.pm)
BuildRequires: perl(Pod/Usage.pm)
BuildRequires: perl(Test/Differences.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(autodie.pm)
BuildRequires: perl(overload.pm)
BuildRequires: perl(parent.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(utf8.pm)
BuildRequires: perl(vars.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This is a CPAN Perl module that verifies the solutions of various variants
of card Solitaire. It does not aim to try to be a solver for them, because
this is too CPU intensive to be adequately done using perl5 (as of
perl-5.10.0). If you're interested in the latter, look at:

* https://fc-solve.shlomifish.org/

* https://fc-solve.shlomifish.org/links.html#other_solvers

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL --installdirs=vendor

./Build CFLAGS="%{optflags}"

%check
./Build test

%install
./Build install --destdir=%{buildroot}

%files
%doc COPYING Changes LICENSE META.json META.yml  README examples
%perl_vendor_privlib/*
%{_bindir}/verify-solitaire-solution
%{_bindir}/expand-solitaire-multi-card-moves
%{_mandir}/man1/*

%changelog
