# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Geo/Location/Point.pm) perl(Math/Trig.pm) perl(Statistics/Basic.pm) perl(Test/DescribeMe.pm) perl(Test/Most.pm) perl(Test/Needs.pm)
# END SourceDeps(oneline)
%define module_name Geo-AnomalyDetector
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Detect anomalies in geospatial coordinate datasets
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NH/NHORNE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module analyzes latitude and longitude data points to identify anomalies based on their distance from the mean location.

  use Geo::AnomalyDetector;

  my $detector = Geo::AnomalyDetector->new(threshold => 3);
  my $coords = [ [37.7749, -122.4194], [40.7128, -74.0060], [35.6895, 139.6917] ];
  my $anomalies = $detector->detect_anomalies($coords);
  print "Anomalies: " . join ", ", map { "($_->[0], $_->[1])" } @{$anomalies};

Each co-ordinate can be either a two element array of [latitude, longitude] or an object that has
`latitude' and `longitude' methods.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/G*

%changelog
