%define module_name Geo-BUFR
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(DynaLoader.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(FileHandle.pm) perl(Getopt/Long.pm) perl(Pod/Usage.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Test/More.pm) perl(Time/Local.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.39
Release: alt2
Summary: Perl extension for handling of WMO BUFR files.
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PS/PSANNES/%{module_name}-%{version}.tar.gz

%description
BUFR = Binary Universal Form for the Representation of
meteorological data. BUFR is approved by WMO (World Meteorological
Organization) as the standard universal exchange format for
meteorological observations, gradually replacing a lot of older
alphanumeric data formats.

This module provides methods for decoding and encoding BUFR messages,
and for displaying information in BUFR B and D tables and in BUFR flag
and code tables.

Installing this module also installs some programs: `bufrread.pl',
`bufrresolve.pl', `bufrencode.pl', `bufr_reencode.pl' and
`bufralter.pl'. See https://wiki.met.no/bufr.pm/start for examples
of use. For the majority of potential users of Geo::BUFR I would
expect these programs to be all that you will need Geo::BUFR for.

Note that being Perl, this module cannot compete in speed with for
example the (free) ECMWF Fortran library libbufr. Still, some effort
has been put into making the module reasonable fast in that the core
routines for encoding and decoding bitstreams are implemented in C.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release
BuildArch: noarch

%description scripts
scripts for %module_name



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/G*
%perl_vendor_autolib/*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
