# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Math/BigInt.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Geo-Code
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.2
Release: alt1
Summary: The GeoCode of a latitude,longitude point is a ten byte string, three geonames, or a hybrid code. T...
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ER/ERUCI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Encoding geographic coordinates into a string is a trivial thing. Yet, there are many grid based systems (geohash, PlusCodes, Mapcodes), and some even turn the thing into a business (Zippr, What3Words). I agree with the commonly stated motivation that Latitude and Longitude are not sufficient for identifying a place in both an unambiguous and human friendly way. A single string for this pair of numbers is a better representation, if only it can preserve all the information contained in the original latitude,longitude pair, something no existing geo-encoding system does. That's my goal.

Geo::Code is an open source Geolocation Code. It translates between (latitude,longitude) and three types of one dimensional string (one alphanumeric string, a triple geoname combination or a hybrid).

The Alphanumeric Geo::Code is shorter than most alternatives (10 bytes), has higher accuracy (up to 1 meters) and avoids the borderline discontinuities of other one-dimensional location codes such a geohashes and plus codes.

Triple Name Geo::Code is more human readable than alternatives because it uses actual geographic names and maintains location proximity to the latitude,longitude point, with the first geoname in the triple representing the most prominent geo name within 146.3 km of the point. No geoname is longer than 8 bytes.

The hybrid Geo::Code is composed of two parts, one geoname and an alphanumeric string. The Geoname represents the most promiment location name in the points vicinity while the alphanumeric string part indicates weather two points are far or near, based on how many significant digits they have in common.

This module is explained in more detailed on GitHub. View on GitHub.

Online Demo. 3Geonames.org.

Also supported on Geocode.xyz.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/G*

%changelog
