# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl(Math/Trig.pm) perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Geo-Coordinates-UTM
%define upstream_version 0.11

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Translation between  Lat Lon and UTM Coords
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Geo/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildArch:  noarch
Source44: import.info

%description
This module will translate latitude longitude coordinates to Universal
Transverse Mercator(UTM) coordinates and vice versa.

Mercator Projection
    The Mercator projection was first invented to help mariners. They
    needed to be able to take a course and know the distance traveled, and
    draw a line on the map which showed the day's journey. In order to do
    this, Mercator invented a projection which preserved length, by
    projecting the earth's surface onto a cylinder, sharing the same axis
    as the earth itself. This caused all Latitude and Longitude lines to
    intersect at a 90 degree angle, thereby negating the problem that
    longitude lines get closer together at the poles.

Transverse Mercator Projection
    A Transverse Mercator projection takes the cylinder and turns it on its
    side. Now the cylinder's axis passes through the equator, and it can be
    rotated to line up with the area of interest. Many countries use
    Transverse Mercator for their grid systems.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
make test

%install
%makeinstall_std

%files
%doc Changes META.yml  README
%perl_vendor_privlib/*

%changelog
