%define module_name Geo-Elevation-HGT
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find.pm) perl(HTTP/Tiny.pm) perl(IO/Uncompress/AnyUncompress.pm) perl(List/Util.pm) perl(POSIX.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: Elevation service with terrain data provided by L<Mapzen and Amazon AWS S3|https://registry.opendat...
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UL/ULIBUCK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module implements an elevation service with terrain data provided by Mapzen and Amazon AWS S3.

You provide the latitude and longitude in decimal degrees, with south latitude and west longitude being negative.

The return is the elevation for this latitude and longitude in meters.
Bilinear interpolation is applied to the elevations at the four grid points adjacent to the latitude plus longitude pair.

You can also use your own terrain tiles by providing the corresponding path, see below.
A good source for Europe that I am using was compiled by Sonny -- many thanks to him; found at https://data.opendataportal.at/dataset/dtm-europe

In addition you can specify a cache folder for subsequent use of downloaded tiles, see below.

There are only core dependencies

 Carp
 IO::Uncompress::AnyUncompress
 HTTP::Tiny
 POSIX
 File::Find
 List::Util

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes README.md
%perl_vendor_privlib/G*

%changelog
