# BEGIN SourceDeps(oneline):
BuildRequires: perl(Math/Trig.pm)
# END SourceDeps(oneline)
%define module_name Geo-Geocalc
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: operations on geographical coordinates.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ME/MECIN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Geo::Geocalc simple Perl module for coordinates processing. The basic assumptions of this module are: simple, light and clean as possible.

Some of the main functions (code snippets):

    use Geo::Geocalc;

_$distanceInKm = &getDistance($lat1,$lng1,$lat2,$lng2,$R) # calculate distance (km) between two points on Earth.

_$latitudeInDegree = &getLat($lat1,$lng1,$lng2,$distance,$R) # calculate latitude (deg) of the point based on other point and distance on Earth between them.

_$longitudeInDegree = &getLng($lat1,$lng1,$lat2,$distance,$R) # calculate longitude (deg) of the point based on other point and distance on Earth between them.

_&generateKMLPlacemarks($outputKmlFilename, @coordinates); # generate outputKmlFilename.kml with Placemarks based on an array of coordinates (deg) ($lat1, $lng1, $lat2, $lng2, ...)

_&generateKMLPolygons($outputKmlFilename, \%%hashOfCoords); # generate outputKmlFilename.kml with Polygons based on an reference to hash of 0 -> @ of coordinates of corners (deg - $lat1, $lng1, $lat2, $lng2 ...) , recommended to use hash generated with generateGridCoordinates function

_&generateGridCoordinates($lat1, $lng1, $lat2, $lng2, $width, \%%gridCoordinates, $R); # coordinates of opposite corners on Earth to be covered by the grid, size of grid in km, reference to hash of grid output coordinates and optional, Earth radius.

_($qLat, $qLng) = &Geo::Geocalc::randomPlacemarkInsidePolygon(@{$gridCoordinates{$sector}}); # generate random place (latitude and longitude values) inside provided Polygon - array of 4 corners coordinates ($lat1, $lng1, $lat2, $lng2, ...)

    ...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/G*

%changelog
