%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(English.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/Entities.pm) perl(JSON.pm) perl(Math/Trig.pm) perl(Scalar/Util.pm) perl(Test/CheckChanges.pm) perl(Test/CheckManifest.pm) perl(Test/Deep.pm) perl(Test/Differences.pm) perl(Test/JSON.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Prereq.pm) perl(Test/Spelling.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name Geo-Google-MapObject
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Code to help with managing the server side of the Google Maps API
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SI/SILASMONK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module is intended to provide a server side solution to working with the Google Maps API.
In particular an object of this class encapsulates a "map" object that provides support
for the static maps API, the javascript maps API, AJAX calls and non-javascript fallback data;
but without making many assumptions about the surrounding framework.
We do assume that a template framework with support for a "dot" notation is being used, for example the HTML::Template::Pluggable manpage.
An important commitment of the module is support for graceful and consistent fallback to a functional non-javascript web page.

The javascript and static Google map APIs do not behave in quite the same way when zoom and center are not specified.
Specifically it works quite well with the static maps (http://code.google.com/apis/maps/documentation/staticmaps/#ImplicitPositioning)
but not so well with the javascript API.
To compensate for this the module gives a choice between: specifying the center and zoom levels; allowing the APIs and client side code to
do whatever they think best; using a built in algorithm to calculate a sensible zoom and center; and finally supplying ones
own algorithm to calculate a sensible zoom and center.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/G*

%changelog
