# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(DynaLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Math/Trig.pm) perl(Test/More.pm) perl(fields.pm)
# END SourceDeps(oneline)
%define module_name Geo-Index
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.8
Release: alt4
Summary: Geographic indexer
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AK/AKH/%{module_name}-v%{version}.tar.gz

%description
Geo::Index is a Perl module for creating in-memory geographic points indices. 
Once points have been indexed, fast searches can be run.  

Efficient searches methods include `Search(...)' to get all points 
within a distance from a given point, `SearchByBounds(...)' to get all 
points in an given area, `Closest(...)' to get the closest points to a 
given point, and `Farthest(...)' to get the farthest points from a given 
point.

Additional methods are provided to compute distances between arbitrary points 
(E<nbsp>`Distance(...)', `DistanceFrom(...)', and `DistanceTo(...)'E<nbsp>)
and to get the size in meters of one degree or the size in degrees of one meter
at a given point (`OneDegreeInMeters(...)' and `OneMeterInDegrees(...)', 
respectively).

While by default computations are done for the Earth, other bodies can be used 
by supplying appropriates radii and circumferences to `new(...)'.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ignore.txt Changes README.md README LICENSE examples
%perl_vendor_archlib/G*
%perl_vendor_autolib/*

%changelog
