# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Test/More.pm) perl(Geo/Coder/Google.pm)
# END SourceDeps(oneline)
%define module_version 1
%define module_name Geo-OLC
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1
Release: alt1
Summary: API for Google's Open Location Codes
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JG/JGREELY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Open Location Codes are a Google-created method of reducing a
Latitude/Longitude pair to a short string. This module implements the
recommended API from https://github.com/google/open-location-code

    use Geo::OLC qw(encode decode shorten recover_nearest);
    use Geo::OLC qw(:all);

    $code = encode(34.6681375,135.502765625,11);
    # '8Q6QMG93+742'

    $ref = decode('8Q6QMG93+742');
    # @{$ref->{center}} == (34.6681375,135.502765625)

    $short = shorten('8Q6QMG93+742',34.6937048,135.5016142);
    # 'MG93+742' ("...in Osaka")
    $short = shorten('8Q6QMG93+742',34.6788184,135.4987303);
    # '93+742' ("...in Chuo Ward, Osaka")

    $full = recover_nearest('XQP5+',35.0060799,135.6909098);
    # '8Q6QXQP5+' (Kyoto Station, "XQP5+ in Kyoto")

By default, Geo::OLC does not export any functions.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install
# strange perls in '#!'
fix_shabang_in_perl()
{
	local f="$1"
	#!/usr/bin/perl -w -- -*- mode: cperl -*-
	sed -i -e '1s,^#\![[:space:]]*\(/usr\)\?/bin/env[[:space:]]*perl,#!/usr/bin/perl,;1s,-\*-[[:space:]]*cperl[[:space:]]*-\*-,,;1s,-\*-[[:space:]]*[Mm]ode:[[:space:]]*[Cc]?[pP]erl[[:space:]]*-\*-,,' $f 
	sed -i -e '1s,^#\!/usr/local/bin/perl,#!/usr/bin/perl,' $f 
}
for dir in %buildroot%_bindir %buildroot%perl_vendor_archlib %buildroot%perl_vendor_privlib ; do
    if [ -d $dir ]; then
    	find $dir -type f -executable | while read f; do
	  case `file $f` in
	    *perl*) fix_shabang_in_perl $f 
	    ;;
	  esac
	done
	find $dir -type f \( -name '*.pm' -or -name '*.pl' \) | while read f; do
	  fix_shabang_in_perl $f
	done
    fi
done


%files
%doc TODO README
%perl_vendor_privlib/G*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
