%define module_name Geo-OSM-Imager
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Geo/Ellipsoid.pm) perl(HTTP/Request/Common.pm) perl(Imager.pm) perl(LWP/UserAgent.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Math/Trig.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: simplifies plotting onto OpenStreetMap tiles
Group: Development/Perl
License: perl
URL: https://github.com/Firedrake/Geo-OSM-Imager

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FI/FIREDRAKE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module sets up an Imager object made of OpenStreetMap tiles, for
drawing of geographic data.

Beware of over-using OpenStreetMap tile servers, and see the usage
policy at https://operations.osmfoundation.org/policies/tiles/ .

Be hesitant about drawing straight lines over long distances, as map
projections will cause distortion. Over more than a few hundred
metres, the author prefers to break the line into a series of points
and plot individual line segments.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/G*

%changelog
