%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(LWP/UserAgent.pm) perl(Moo.pm) perl(Test/More.pm) perl(Text/CSV.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Geo-USCensus-Geocoding
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: The U.S. Census Bureau geocoding service
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MW/MWELLS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
use Geo::USCensus::Geocoding;

    my $request = {
      # required fields
      street  => '123 Main Street',
      city    => 'San Francisco',   # city
      state   => 'CA',              # state
      # optional fields
      zip     => '93102',           # zip code
      benchmark => 'Public_AR_ACS2013', # default is "Public_AR_Current"
      vintage   => 'Census2010_ACS2013', # default is "Current_Current"

      debug => 1,                   # will print the URL and some other info
    };
    my $result = Geo::USCensus::Geocoding->query($request);

    if ($result->is_match) {
      print $result->address,"\n",
            $result->latitude,", ",$result->longitude,"\n",
            $result->censustract,"\n";
    } else {
      print "No match.\n";
    }
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/G*

%changelog
