%define module_version 20140611
%define module_name Gerrit-Client
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/git perl(AnyEvent.pm) perl(AnyEvent/HTTP.pm) perl(AnyEvent/Handle.pm) perl(AnyEvent/Socket.pm) perl(AnyEvent/Util.pm) perl(Archive/Zip.pm) perl(Capture/Tiny.pm) perl(Config.pm) perl(Data/Alias.pm) perl(Digest/MD5.pm) perl(Dir/Self.pm) perl(English.pm) perl(Env/Path.pm) perl(Errno.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(File/chdir.pm) perl(FindBin.pm) perl(IO/File.pm) perl(JSON.pm) perl(LWP.pm) perl(LWP/UserAgent.pm) perl(Lingua/EN/CommonMistakes.pm) perl(List/MoreUtils.pm) perl(MIME/Base64.pm) perl(Params/Validate.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Sub/Override.pm) perl(Test/More.pm) perl(Test/Warn.pm) perl(URI.pm) perl(URI/Escape.pm) perl(autodie.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 20140611
Release: alt1
Summary: interact with Gerrit code review tool
Group: Development/Perl
License: lgpl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RO/ROHANPM/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
use AnyEvent;
  use Gerrit::Client qw(stream_events);

  # alert me when new patch sets arrive in
  # ssh://gerrit.example.com:29418/myproject
  my $stream = stream_events(
    url => 'ssh://gerrit.example.com:29418',
    on_event => sub {
      my ($event) = @_;
      if ($event->{type} eq 'patchset-added'
          && $event->{change}{project} eq 'myproject') {
        system("xmessage", "New patch set arrived!");
      }
    }
  );

  AE::cv()->recv(); # must run an event loop for callbacks to be activated

This module provides some utility functions for interacting with the Gerrit code
review tool.

This module is an the AnyEvent manpage user and may be used with any event loop supported
by AnyEvent.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE examples
%perl_vendor_privlib/G*

%changelog
