%define module_version 1.0.6
%define module_name Getopt-ArgParse
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Getopt/Long.pm) perl(Moo.pm) perl(Scalar/Util.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Text/Wrap.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.6
Release: alt1
Summary: Parsing args with a richer and more user-friendly API
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MY/MYTRAM/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
use Getopt::ArgParse;.
 $ap = Getopt::ArgParse->new_parser(
 	prog        => 'MyProgramName',
 	description => 'This is a program',
    epilog      => 'This appears at the bottom of usage',
 );

 # Parse an option: '--foo value' or '-f value'
 $ap->add_arg('--foo', '-f', required => 1);

 # Parse a boolean: '--bool' or '-b' using a different name from
 # the option
 $ap->add_arg('--bool', '-b', type => 'Bool', dest => 'boo');

 # Parse a positonal option.
 # But in this case, better using subcommand. See below
 $ap->add_arg('command', required => 1);

 # $ns is also accessible via $ap->namespace
 $ns = $ap->parse_args(split(' ', 'test -f 1 -b'));

 say $ns->command; # 'test'
 say $ns->foo;     # false
 say $ns->boo;     # false
 say $ns->no_boo;   # true - 'no_' is added for boolean options

 # You can continue to add arguments and parse them again
 # $ap->namespace is accumulatively populated

 # Parse an Array type option and split the value into an array of values
 $ap->add_arg('--emails', type => 'Array', split => ',');
 $ns = $ap->parse_args(split(' ', '--emails a@perl.org,b@perl.org,c@perl.org'));
 # Because this is an array option, this also allows you to specify the
 # option multiple times and splitting
 $ns = $ap->parse_args(split(' ', '--emails a@perl.org,b@perl.org --emails c@perl.org'));

 # Below will print: a@perl.org|b@perl.org|c@perl.org|a@perl.org|b@perl.org|c@perl.org
 # Because Array types are appended
 say join('|', $ns->emails);

 # Parse an option as key,value pairs
 $ap->add_arg('--param', type => 'Pair', split => ',');
 $ns = $ap->parse_args(split(' ', '--param a=1,b=2,c=3'));

 say $ns->param->{a}; # 1
 say $ns->param->{b}; # 2
 say $ns->param->{c}; # 3

 # You can use choice to restrict values
 $ap->add_arg('--env', choices => [ 'dev', 'prod' ],);

 # or use case-insensitive choices
 # Override the previous option with reset
 $ap->add_arg('--env', choices_i => [ 'dev', 'prod' ], reset => 1);

 # or use a coderef
 # Override the previous option
 $ap->add_args(
 	'--env',
 	choices => sub {
 		die "--env invalid values" if $_[0] !~ /^(dev|prod)$/i;
 	},
    reset => 1,
 );

 # subcommands
 $ap->add_subparsers(title => 'subcommands'); # Must be called to initialize subcommand parsing
 $list_parser = $ap->add_parser(
         'list',
         help => 'List directory entries',
         description => 'A multiple paragraphs long description.',
 );

 $list_parser->add_args(
   [
     '--verbose', '-v',
      type => 'Count',
      help => 'Verbosity',
   ],
   [
     '--depth',
      help => 'depth',
   ],
 );

 $ns = $ap->parse_args(split(' ', 'list -v'));

 say $ns->current_command(); # current_command stores list,
                             # Don't use this name for your own option

 $ns =$ap->parse_args(split(' ', 'help list')); # This will print the usage for the list command
 # help subcommand is automatically added for you
 say $ns->help_command(); # list

 # Copy parsing
 $common_args = Getopt::ArgParse->new_parser();
 $common_args->add_args(
   [
     '--dry-run',
      type => 'Bool',
      help => 'Dry run',
   ],
 );

 $sp = $ap->add_parser(
   'remove',
   aliases => [qw(rm)],           # prog remove or prog rm
   parents => [ $command_args ],  # prog rm --dry-run
 );

 # Or copy explicitly
 $sp = $ap->add_parser(
   'copy',
   aliases => [qw(cp)],           # prog remove or prog rm
 );

 $sp->copy_args($command_parser); # You can also copy_parsers() but in this case
                                  # $common_parser doesn't have subparsers


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md TODO Changes
%perl_vendor_privlib/G*

%changelog
