# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Attribute/Handlers.pm) perl(English.pm) perl(Scalar/Util.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Getopt-Attribute
%define upstream_version 2.101700

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Attribute wrapper for Getopt::Long
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Getopt/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Test/Compile.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(UNIVERSAL/require.pm)

BuildArch: noarch
Source44: import.info


%description
Note: This version of the module works works with perl 5.8.0. If you need
it to work with perl 5.6.x, please use an earlier version from CPAN.

This module provides an attribute wrapper around 'Getopt::Long'. Instead of
declaring the options in a hash with references to the variables and
subroutines affected by the options, you can use the 'Getopt' attribute on
the variables and subroutines directly.

As you can see from the Synopsis, the attribute takes an argument of the
same format as you would give as the hash key for 'Getopt::Long'. See the
'Getopt::Long' manpage for details.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%{make}

%check
%{make} test

%install
%makeinstall_std

%files
%doc Changes README META.yml
%perl_vendor_privlib/*

%changelog
