# BEGIN SourceDeps(oneline):
BuildRequires: perl(Math/RPN.pm) perl(Module/Build/Tiny.pm) perl(Term/ReadKey.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Getopt-EX-RPN
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: RPN calculation module for Getopt::EX command option
Group: Development/Perl
License: perl
URL: https://github.com/kaz-utashiro/Getopt-EX-RPN

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UT/UTASHIRO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Getopt::EX::RPN is a wrapper for the Math::RPN manpage package which implement
Reverse Polish Notation calculation.  rpn_calc function in this
package takes additional `HEIGHT' and `WIDTH' token which describe
terminal height and width.

rpn_calc recognize following tokens (case-insensitive) and numbers,
and ignore anything else.  So you can use any other character as a
delimiter.  Delimiter is not necessary if token boundary is clear.

    HEIGHT  WIDTH
    {   }
    +,ADD  ++,INCR  -,SUB  --,DECR  *,MUL  /,DIV  %%,MOD  POW  SQRT
    SIN  COS  TAN
    LOG  EXP
    ABS  INT
    &,AND  |,OR  !,NOT  XOR  ~
    <,LT  <=,LE  =,==,EQ  >,GT  >=,GE  !=,NE
    IF
    DUP  EXCH  POP
    MIN  MAX
    TIME
    RAND  LRAND

Since module the Getopt::EX::Func manpage uses comma to separate parameters,
you can't use comma as a token separator in RPN expression.  This
package accept expression like this:

    &set(width=WIDTH:2/,height=HEIGHT:DUP:2%%-2/)

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/G*

%changelog
