Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(QWizard.pm) perl(QWizard/Plugins/Bookmarks.pm) perl(QWizard/Storage/File.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Getopt-GUI-Long
Version:        0.93
Release:        alt2_28
Summary:        A wrapper around Getopt::Long to provide a GUI to applications
License:        GPL+ or Artistic 
URL:            https://metacpan.org/release/Getopt-GUI-Long
Source0:        https://cpan.metacpan.org/authors/id/H/HA/HARDAKER/Getopt-GUI-Long-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(Test/More.pm)
# These are not auto-detected since they're technically optional
# (they're the best of the alternative choices available on linux)
Requires:       perl(QWizard.pm)
Requires:       perl(Gtk2.pm)
Source44: import.info

# neither are picked up automagically.

%description
This module is a wrapper around Getopt::Long that extends the value of
the original Getopt::Long module to:

1) add a simple graphical user interface option screen if no arguments
   are passed to the program.  Thus, the arguments to actually use are
   built based on the results of the user interface. If arguments were
   passed to the program, the user interface is not shown and the
   program executes as it normally would and acts just as if
   Getopt::Long::GetOptions had been called instead.  This requires
   the QWizard and Gtk2 or Tk interfaces to be installed too.

2) provide an auto-help mechanism such that -h and --help are
   handled automatically.  In fact, calling your program with -h
   will default to showing the user a list of short-style arguments
   when one exists for the option.  Similarly --help will show the
   user a list of long-style when possible.  --help-full will list
   all potential arguments for an option (short and long both).

It's designed to make the creation of graphical shells trivial
without the programmer having to think about it much as well as
providing automatic good-looking usage output without the
programmer needing to write usage() functions.

%prep
%setup -q -n Getopt-GUI-Long-%{version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install

make pure_install PERL_INSTALL_ROOT=%{buildroot}

find %{buildroot} -type f -name .packlist -exec rm -f {} \;
find %{buildroot} -depth -type d -exec rmdir {} 2>/dev/null \;

# %{_fixperms} %{buildroot}/*

# rpm doc examples shouldn't be executable
chmod a-x examples/*

%files
%doc examples/
%doc README
%{perl_vendor_privlib}/*

%changelog
