Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(File/Fetch.pm) perl(LWP/Simple.pm) perl(LWP/UserAgent.pm) perl(Package/Constants.pm) perl(Pod/Usage.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Git-CPAN-Patch
Summary:        Patch CPAN modules using Git
Version:        2.5.0
Release:        alt1_7
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
Source0:        https://cpan.metacpan.org/authors/id/Y/YA/YANICK/Git-CPAN-Patch-%{version}.tar.gz
URL:            https://metacpan.org/release/Git-CPAN-Patch
BuildArch:      noarch
# Build
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Runtime
BuildRequires:  perl(Archive/Any.pm)
BuildRequires:  perl(Archive/Extract.pm)
BuildRequires:  perl(autodie.pm)
BuildRequires:  perl(BackPAN/Index.pm)
BuildRequires:  perl(CPAN/Meta.pm)
BuildRequires:  perl(CPAN/ParseDistribution.pm)
BuildRequires:  perl(CPANPLUS.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(DateTime.pm)
BuildRequires:  perl(experimental.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/chdir.pm)
BuildRequires:  perl(File/chmod.pm)
BuildRequires:  perl(File/Copy.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(Git/Repository.pm)
BuildRequires:  perl(List/Pairwise.pm)
# BuildRequires:  perl(LWP::Simple)
# BuildRequires:  perl(LWP::UserAgent)
BuildRequires:  perl(MetaCPAN/API.pm)
BuildRequires:  perl(MetaCPAN/Client.pm)
BuildRequires:  perl(Moose.pm)
BuildRequires:  perl(Moose/Role.pm)
BuildRequires:  perl(MooseX/App.pm)
BuildRequires:  perl(MooseX/App/Command.pm)
BuildRequires:  perl(MooseX/App/Role.pm)
BuildRequires:  perl(MooseX/SemiAffordanceAccessor.pm)
BuildRequires:  perl(Path/Class.pm)
BuildRequires:  perl(Path/Tiny.pm)
# BuildRequires:  perl(Pod::Usage)
BuildRequires:  perl(Test/More.pm)
# Tests only
BuildRequires:  git
BuildRequires:  perl(blib.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(DDP.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(Git/Repository/Plugin/AUTOLOAD.pm)
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(IPC/Open3.pm)
BuildRequires:  perl(Test/MockObject.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       git
Requires:       perl(CPAN/Meta.pm)
Requires:       perl(CPAN/ParseDistribution.pm)
Requires:       perl(File/Copy.pm)
Requires:       perl(LWP/Simple.pm)
Requires:       perl(LWP/Protocol/ftp.pm)
Requires:       perl(LWP/Protocol/http.pm)
Requires:       perl(LWP/UserAgent.pm)


Source44: import.info

%description
Git::CPAN::Patch provides a suite of git commands aimed at making trivially
easy the process of grabbing any distribution off CPAN, stuffing it in a
local git repository and, once gleeful hacking has been perpetrated,
sending back patches to its maintainer.

This package provides the backend Perl modules required.  For the git
commands, etc, please install the git-cpan-patch package.

%package -n git-cpan-patch
Group: Development/Perl
Summary:        Patch CPAN modules using Git
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
Requires:       perl-Git-CPAN-Patch = %{version}-%{release}
Requires:       git, git-email

%description -n git-cpan-patch
git-cpan-patch provides a suite of git commands aimed at making trivially
easy the process of grabbing any distribution off CPAN, stuffing it in a
local git repository and, once gleeful hacking has been perpetrated,
sending back patches to its maintainer.

%package tests
Group: Development/Perl
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       git
Requires:       perl(Git/Repository/Plugin/AUTOLOAD.pm)

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Git-CPAN-Patch-%{version}
# Fix shellbang
perl -MConfig -pi -e 's|^#!/usr/bin/env perl|$Config{startperl} |' bin/git-cpan
# Help generators to recognize Perl scripts
for F in t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!.*perl\b}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*
# upstream now installs to /usr/bin; we still prefer /usr/libexec/git-core
install -d -m 0755 %{buildroot}%{_libexecdir}/git-core
mv %{buildroot}/%{_bindir}/* %{buildroot}%{_libexecdir}/git-core/

# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
mkdir -p %{buildroot}%{_libexecdir}/%{name}/bin
ln -s %{_libexecdir}/git-core/git-cpan %{buildroot}%{_libexecdir}/%{name}/bin
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
git config --global user.email "perl-Git-CPAN-Patch-owner@fedoraproject.org"
git config --global user.name "perl-Git-CPAN-Patch Owner"
git config --global init.defaultBranch "development"
set -e
# Some tests write into temporary files/directories. The easiest solution
# is to copy the tests into a writable directory and execute them from there.
DIR=$(mktemp -d)
pushd "$DIR"
cp -a %{_libexecdir}/%{name}/* ./
prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
popd
rm -rf "$DIR"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
git config --global user.email "perl-Git-CPAN-Patch-owner@fedoraproject.org"
git config --global user.name "perl-Git-CPAN-Patch Owner"
git config --global init.defaultBranch "development"
make test

%files
%doc --no-dereference LICENSE
%doc AUTHOR_PLEDGE Changes README.mkdn
%{perl_vendor_privlib}/*

%files -n git-cpan-patch
%doc --no-dereference LICENSE
%doc AUTHOR_PLEDGE Changes README.mkdn
%{_libexecdir}/git-core
%{_mandir}/man1/*

%files tests
%{_libexecdir}/%{name}

%changelog
