# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(File/Temp.pm) perl(Git/Version/Compare.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(System/Command.pm) perl(Test/Builder.pm) perl(Test/CPAN/Meta.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Requires/Git.pm) perl(constant.pm) perl(lib.pm) perl(namespace/clean.pm) perl(overload.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Git-Repository
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.325
Release: alt1
Summary: Perl interface to Git repositories
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BO/BOOK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Git::Repository manpage is a Perl interface to Git, for scripted interactions
with repositories. It's a low-level interface that allows calling any Git
command, whether *porcelain* or *plumbing*, including bidirectional
commands such as `git commit-tree'.

A the Git::Repository manpage object simply provides context to the git commands
being run. It is possible to call the  `command()' and `run()' methods
against the class itself, and the context (typically *current working
directory*) will be obtained from the options and environment.

As a low-level interface, it provides no sugar for particular Git
commands. Specifically, it will not prepare environment variables that
individual Git commands may need or use.

However, the `GIT_DIR' and `GIT_WORK_TREE' environment variables are
special: if the command is run in the context of a the Git::Repository manpage
object, they will be overridden by the object's `git_dir' and
`work_tree' attributes, respectively. It is still possible to
override them if necessary, using the `env' option.

the Git::Repository manpage requires at least Git 1.5.0, and is expected to support
any later version.

See the Git::Repository::Tutorial manpage for more code examples.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/T*
%perl_vendor_privlib/G*

%changelog
