%define module_name Glib-IO
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Glib/Object/Introspection.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Perl bindings to the GIO library
Group: Development/Perl
License: lgpl
URL: http://gtk2-perl.sourceforge.net

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/X/XA/XAOC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The `Glib::IO' module allows a Perl developer to access the GIO library, the
high level I/O and platform library of the GNOME development platform. GIO is
used for:

=over

=item * local and remote enumeration and access of files

GIO has multiple backends to access local file systems; SMB/CIFS volumes;
WebDAV resources; compressed archives; local devices and remote web services.

=item * stream based I/O

Including files, memory buffers, and network streams.

=item * low level and high level network operations

Sockets, Internet addresses, datagram-based connections, and TCP connections.

=item * TLS/SSL support for socket connections

=item * DNS resolution and proxy

=item * low level and high level DBus classes

GIO allows the implementation of clients and servers, as well as proxying
objects over DBus connections.

=back

Additionally, GIO has a collection of high level classes for writing
applications that integrate with the platform, like:

=over

=item settings

=item network monitoring

=item a base Application class

=item extensible data models

=item content type matching

=item application information and launch

=back

For more information, please visit the GIO reference manual available on
https://developer.gnome.org/gio/stable. The Perl API closely matches the
C one, and eventual deviations will be documented here.

The principles underlying the mapping from C to Perl are explained in the
documentation of the Glib::Object::Introspection manpage, on which `Glib::IO' is based.

the Glib::Object::Introspection manpage also comes with the `perli11ndoc' program which
displays the API reference documentation of all installed libraries organized
in accordance with these principles.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README NEWS LICENSE
%perl_vendor_privlib/G*

%changelog
