%define module_name Graph-Grammar
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Clone.pm) perl(ExtUtils/MakeMaker.pm) perl(Graph.pm) perl(Graph/MoreUtils.pm) perl(List/Util.pm) perl(Set/Object.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.0
Release: alt1
Summary: Grammar for graphs
Group: Development/Perl
License: bsd
URL: https://search.cpan.org/dist/Graph-Grammar

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ME/MERKYS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Graph::Grammar is a Perl implementation of a graph rewriting method (a.k.a. graph grammar).
Much of the API draws inspiration from the Parse::Yapp manpage, but instead of acting on text streams Graph::Grammar is oriented at graphs, as implemented in Perl's the Graph manpage module.
Graph::Grammar implements a single method `parse_graph()' which accepts an instance of the Graph manpage and an array of rules.
Every rule is evaluated for each vertex in a graph and, if a match is found, an action associated with the rule is executed.
A rule generally looks like this:

    [ $vertex_condition, @neighbour_conditions, $action ]

Where:

`$vertex_condition' is a subroutine reference evaluating the center node.
The subroutine is called with the graph in `$_[0]' and the vertex in <$_[1]>.
Subroutine should evaluate to true if condition is fulfilled.

`@neighbour_conditions' is an array of subroutine references for the neighbours of the center node.
Inputs and outputs of each subroutine reference are the same as defined for `$vertex_condition'.
Every condition has to match at least one of the neighbours (without overlaps).
Thus the rule will automatically fail if the number of neighbours is less than `@neighbour_conditions'.
There can be more neighbours than `@neighbour_conditions', but if strict number of neighbours is needed, look below for `NO_MORE_VERTICES'.
`@neighbour_conditions' can be empty.

`$action' can be either a subroutine reference, or anything else.
If `$action' is a subroutine reference, then in the case of a match it is called with the graph in `$_[0]' and remaining `@_' members being graph vertices corresponding to rule conditions.
That is, `$_[1]' is the center node, `$_[2]' is a vertice matching the first neighbour condition and so on.
If `$action' is not a subroutine reference, then it is cloned by the Clone manpage and inserted instead of the center vertex.

There are two ways to request a particular number of neighbours for the central vertex.
First of them is to include an appropriate requir...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/G*

%changelog
