%define module_name Graph-Graph6
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Devel/TimeThis.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/HomeDir.pm) perl(File/Map.pm) perl(File/Slurp.pm) perl(Geometry/AffineTransform.pm) perl(Graph.pm) perl(Graph/Easy.pm) perl(Graph/Easy/Parser.pm) perl(Graph/Reader.pm) perl(Graph/Writer.pm) perl(HTML/Entities.pm) perl(HTTP/Request/Common.pm) perl(IO/String.pm) perl(IPC/Run.pm) perl(LWP/UserAgent.pm) perl(List/Util.pm) perl(Math/BigInt.pm) perl(Math/PlanePath/SierpinskiTriangle.pm) perl(Math/Trig.pm) perl(Module/Load.pm) perl(Moo.pm) perl(Path/Class.pm) perl(Smart/Comments.pm) perl(Taint/Util.pm) perl(Test.pm) perl(URI/data.pm) perl(constant/defer.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 9
Release: alt1
Summary: Read and write graph6 and sparse6.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/graph-graph6/index.html

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KR/KRYDE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module reads and writes graph6 or sparse6 files.  These file formats
are per

=over 4

http://cs.anu.edu.au/~bdm/data/formats.txt

=back

Both represent an undirected graph with vertices numbered 0 to n-1 encoded
into printable ascii characters in the range `?' to `~'.

The maximum number of vertices is 2^36-1.  sparse6 lists edges as pairs of
vertices i,j and is good for large graphs with relatively few edges.  graph6
is an upper triangle adjacency matrix of bits.  The encoding is 6 bits per
character so N vertices is a file size roughly N^2/12 bytes.  sparse6 can
have multi-edges and self loops.  graph6 does not.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes COPYING examples
%perl_vendor_privlib/G*

%changelog
