# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Trait.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(List/MoreUtils.pm) perl(Module/Build.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod/Coverage.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Graph-PetriNet
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Perl extension for Petri Nets
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DR/DRRHO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This package implements a bipartite graph to represent and interpret a *Petri net*
(http://en.wikipedia.org/wiki/Petri_net). Accordingly, there are two kinds of nodes:

=over

=item *

the Data nodes entry elsewhere in this document carry the information to be processed and/or propagated. This package assumes that each
such node has a unique label (just a string). The label is used to refer to the node.

=item *

the Transition nodes entry elsewhere in this document carry the information how and when processing has to occur. Also transitions
have unique labels and also they are objects. Every transition node has a set of incoming data nodes
from which it can consume data. And it has a set of outgoing data nodes which will be fill with new
data after a transition.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README TODO
%perl_vendor_privlib/G*

%changelog
