%define module_version 0.5.0
%define module_name Graphics-ColorObject
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Graphics/ColorNames.pm) perl(Image/Magick.pm) perl(Math/Trig.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.5.0
Release: alt2
Summary: convert between color spaces
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AI/AIZVORSKI/%module_name-%module_version.tar.gz
BuildArch: noarch
Provides: perl(Graphics/ColorObject.pm) = 0.500

%description
For any supported color space XXX, there is one constructor new_XXX that creates a color using data in that color space, and one method as_XXX that returns the current color as expressed in that color space.  For example, for RGB there is new_RGB and as_RGB.  The color data is always passed as an array reference to a three-element array (four-element in the case of CMYK).  Thus, to convert from RGB to HSL, you can use:

  $color = Graphics::ColorObject->new_RGB([$r, $g, $b]);
  ($h, $s, $l) = @{ $color->as_HSL() };

The constructor can always take a hash of optional arguments in addition to the color value, namely the working RGB space and the white point.  For example:

  $color = Graphics::ColorObject->new_RGB([$r, $g, $b], space=>'Adobe', white_point=>'D65');

For a list of all supported color spaces, call Graphics::ColorObject->list_colorspaces().  For a list of all RGB working spaces and of all white points that this module supports, call Graphics::ColorObject->list_rgb_spaces() and Graphics::ColorObject->list_white_points().

If not specified, the working RGB space will be sRGB.  Many non-RGB conversions also rely on an implicit RGB space, and passing an RGB space as an option (either to the constructor or later) will have an effect on the values.



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/G*

%changelog
