%define module_name Gtk2-Ex-Clock
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(DateTime/TimeZone.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(Glib/Ex/SourceIds.pm) perl(Glib/Object/Subclass.pm) perl(Gtk2.pm) perl(HTML/Entities.pm) perl(List/Util.pm) perl(POSIX/Wide.pm) perl(Pod/Simple/HTML.pm) perl(Test/More.pm) perl(Tie/TZ.pm) perl(Time/Mock.pm) perl(Tk.pm) perl(Tk/StrfClock.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 16
Release: alt1
Summary: Simple digital clock widget.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/gtk2-ex-clock/index.html

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KR/KRYDE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Gtk2::Ex::Clock' displays a digital clock.  The default is 24-hour format
"%%H:%%M" local time, like "14:59".  The properties below allow other formats
and/or a specified timezone.  Pango markup like "<bold>" can be included for
font effects.

`Gtk2::Ex::Clock' is designed to be light weight and suitable for use
somewhere unobtrusive in a realtime or semi-realtime application.  The
right-hand end of a menubar is a good place for instance, depending on user
preferences.

In the default minutes display all a Clock costs in the program is a timer
waking once a minute to change a `Gtk2::Label'.

If you've got a 7-segment LED style font you can display alarm clock style
by selecting that font in the usual ways from an RC file setting or Pango
markup.  examples/7seg.pl in the sources does it with Pango markup and
Harvey Twyman's font.  (Unzip into your ~/.fonts directory.)

=over

http://www.twyman.org.uk/Fonts/

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes COPYING examples
%perl_vendor_privlib/G*

%changelog
