# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Glib.pm) perl(Glib/Ex/SignalIds.pm) perl(Glib/Object/Subclass.pm) perl(Gtk2.pm) perl(Gtk2/Ex/SyncCall.pm) perl(Gtk2/Ex/WidgetCursor.pm) perl(Gtk2/Ex/WidgetEvents.pm) perl(List/Util.pm) perl(Locale/Messages.pm) perl(Pod/Simple/HTML.pm) perl(Scalar/Util.pm) perl(Smart/Comments.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 10
%define module_name Gtk2-Ex-Dragger
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 10
Release: alt1
Summary: Mouse drag to move widget contents.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/gtk2-ex-dragger/index.html

Source0: http://cpan.org.ua/authors/id/K/KR/KRYDE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
`Gtk2::Ex::Dragger' implements mouse pointer dragging to move the contents
of a widget horizontally, vertically, or both.  It works on any windowed
widget which has `Gtk2::Adjustment' objects controlling the visible part.

The width or height of the widget corresponds to the "page" in the
adjustment.  Dragger scales pixel movement onto the adjustment "value"
accordingly.  It's then up to the usual widget drawing to follow
`value-changed' signals from the adjustment for redraws, the same as for
scrollbars etc.  The effect for the user is that the contents are pulled
around with the mouse.

                 Adjustment
                      +--+ --upper
                      |  |
     Window           |  |
    +-------------+ \ |  |
    |             |  \|  |
    |             |   +--+ \_ page size
    |             |   |  | /
    |             |   +--+ ___ value
    |             |  /|  |
    +-------------+ / |  |
                      |  |
                      |  |
                      +--+ --lower

If you've got scrollbars then they move with the dragging too.  It can be
good to have both ways of moving since the scrollbars give visual feedback
but dragging allows finer movements if the visible page is a very small part
of the total adjustable extent.

The "confine" option lets you to restrict mouse movement to screen positions
corresponding to the adjustment upper/lower, so the user gets an obvious
feedback at the limits.

The "cursor" option changes the mouse pointer cursor while dragging.  This
is good if it's not clear for a given widget which button press etc
activates a drag.  The cursor is set through WidgetCursor (see
the Gtk2::Ex::WidgetCursor manpage) and so cooperates with other uses of that.  See
examples/heart.pl in the Gtk2-Ex-Dragger sources, or examples/busy.pl
for the global "busy" indication.

Dragger can work on both natively scrollable widgets and widgets put into a
`Gtk2::Viewport'.  For a viewport it's the viewport widget which is passed
to the dragger since that's the widget showing a portion of a larger
underlying thing.  (Eg. examples/textview.pl natively or
examples/label.pl and examples/layout.pl in a Viewport or Layout, and
examples/vruler.pl with separately jigged up adjusters.)

Changes to the adjustment value, upper/lower, page size, or the widget
window size are all allowed during a drag.  A change to the value could come
from a keyboard page-up etc.  In all cases the Dragger continues relative to
the new position and will update any "confine" window limits.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING README Changes examples
%perl_vendor_privlib/G*

%changelog
