%define module_version 11
%define module_name Gtk2-Ex-ListModelConcat
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Devel/StackTrace.pm) perl(ExtUtils/MakeMaker.pm) perl(Glib.pm) perl(Glib/Ex/SignalIds.pm) perl(Glib/Object/Subclass.pm) perl(Gtk2.pm) perl(Gtk2/Ex/TreeModel/ImplBits.pm) perl(List/Util.pm) perl(Pod/Simple/HTML.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Weaken/Gtk2.pm) perl(base.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 11
Release: alt1
Summary: Concatenate list models in Gtk2-Perl.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/gtk2-ex-listmodelconcat/index.html

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KR/KRYDE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
`Gtk2::Ex::ListModelConcat' presents a set of list type TreeModels
concatenated together as a single list.  A Concat doesn't hold any data
itself, it just presents the sub-models' content.  `Gtk2::ListStore'
objects are suitable as the sub-models, but any similar list-type model can
be used.

                    +--------+
            / row 0 | apple  | row 0 \
           /        +--------+        \
           |  row 1 | orange | row 1  | first child
           |        +--------+        /
           |  row 2 | lemon  | row 2 /
           |        +--------+
    Concat |  row 3 | potato | row 0 \
           |        +--------+        \
           |  row 4 | carrot | row 1  |
           |        +--------+        | second child
           |  row 5 | squash | row 2  |
           \        +--------+        /
            \ row 6 | onion  | row 3 /
                    +--------+


Changes in the sub-models are reported up through the Concat with the usual
`row-changed' etc signals.  Conversely change methods are implemented by
the Concat in the style of `Gtk2::ListStore' and if the sub-models have
those functions too (eg. if they're ListStores) then changes on the Concat
are applied down to the sub-models.

The sub-models should have the same number of columns and the same column
types (or compatible types), though currently ListModelConcat doesn't try to
enforce that.  It works to put one Concat inside another, except of course
it cannot be inside itself (directly or indirectly).


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README COPYING Changes examples
%perl_vendor_privlib/G*

%changelog
