# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Glib/Object/Subclass.pm) perl(Gtk2.pm)
# END SourceDeps(oneline)
%define module_version 4
%define module_name Gtk2-Ex-NoShrink
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 4
Release: alt1
Summary: Non-shrinking container widget for Gtk.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/gtk2-ex-noshrink/index.html

Source0: http://cpan.org.ua/authors/id/K/KR/KRYDE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
A `Gtk2::Ex::NoShrink' container widget holds a single child widget and
imposes a "no shrink" policy on its size.  The child can grow, but any
request to shrink is ignored.

When the child requests a size the NoShrink sets that as the size it
requests in turn from its parent.  If the child later changes asks to be
smaller, the NoShrink stays at the previous larger size, thus keeping the
child's largest-ever request.  A largest size is maintained separately for
width and for height.

Requested sizes are of course just that: only requests.  It's a matter for
the NoShrink's parent how much space is actually provided.  The NoShink
always sets its child to the full allocated space, less the usual
`border-width' (see the Gtk2::Container manpage) if that's set.  As usual it's then
a matter for the child what it does in a size perhaps bigger or perhaps
smaller than what it said it wanted.

If a child is added but not shown (no `$child->show') then it's treated
as if there was no child.  This is the same as other container classes do.
For NoShrink it means a size request of the `minimum-width' by
`minimum-height', plus `border-width', and nothing drawn.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING README Changes examples
%perl_vendor_privlib/G*

%changelog
