# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Glib/Object/Subclass.pm) perl(Gtk2.pm) perl(Gtk2/Ex/AdjustmentBits.pm) perl(Gtk2/Ex/ToolItem/CheckButton.pm) perl(Gtk2/Ex/Units.pm) perl(Gtk2/Ex/WidgetBits.pm) perl(List/Util.pm) perl(Locale/Messages.pm) perl(Pod/Simple/HTML.pm) perl(Scalar/Util.pm) perl(Smart/Comments.pm) perl(Test/More.pm) perl(Test/Weaken/Gtk2.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 1
%define module_name Gtk2-Ex-QuadButton
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1
Release: alt1
Summary: Widget for four arrow directions.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/gtk2-ex-quadbutton/index.html

Source0: http://cpan.org.ua/authors/id/K/KR/KRYDE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
A QuadButton button presents up, down, left and right arrows for the user to
click within a single button,

    +-------------------+
    |         /\        |
    |        /  \       |
    |         ||        |
    |  / -----  ----- \ |
    |  \ -----  ----- / |
    |         ||        |
    |        \  /       |
    |         \/        |
    +-------------------+

A `clicked' signal is emitted with a `Gtk2::ScrollType' like `step-up',
`page-right' etc.  A normal click is a "step" and if the control key is
held down then a "page".

ScrollType is oriented towards stepping or paging something in the display.
See `Gtk2::Ex::QuadButton::Scroll' to act on
`Gtk2::Adjustment' objects.  The ScrollType reaches a Perl code signal
handler as a string, so it's easy to strip the `step-' or `page-' part if
only interested in the direction.

Moving the mouse pointer across the QuadButton shows the prospective
direction as "prelight".  In the Gtk default "Raleigh" theme prelight
foreground colour is the same as normal foreground, so only the background
is highlighted.  This can make it a little hard to see, but doesn't affect
clicking of course.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING Changes examples
%perl_vendor_privlib/G*

%changelog
