%define module_name Gtk2-Ex-WidgetCursor
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Glib/Ex/SignalIds.pm) perl(Glib/Object/Subclass.pm) perl(Gtk2.pm) perl(HTML/Entities.pm) perl(Pod/Simple/HTML.pm) perl(Scalar/Util.pm) perl(Test/Weaken/Gtk2.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 16
Release: alt2
Summary: Mouse pointer cursor management for Gtk widgets.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/gtk2-ex-widgetcursor/index.html

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KR/KRYDE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
WidgetCursor manages the mouse pointer cursor shown in widget windows as per
`Gtk2::Gdk::Window' `set_cursor'.  A "busy" mechanism can display a
wristwatch in all windows when the whole application is blocked.

With the plain window `set_cursor' it's difficult for widget add-ons or
independent parts of an application to cooperate with what should be shown
at different times or in different modes.

A `Gtk2::Ex::WidgetCursor' object represents a desired cursor in one or
more widgets.  When "active" and when it's the newest or highest priority
then the specified cursor is set onto those widget window(s).  If the
WidgetCursor object is later made inactive or destroyed then the next
remaining highest WidgetCursor takes effect, etc.

The idea is to have say a base WidgetCursor for an overall mode, then
something else temporarily while dragging, and perhaps a wristwatch "busy"
indication trumping one or both (like the global "busy" mechanism below).

=for me -- becomes /usr/share/doc/... in the deb

The examples subdirectory in the WidgetCursor sources has some variously
contrived sample programs.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING Changes README examples
%perl_vendor_privlib/G*

%changelog
