%define module_name Gtk2-Ex-Xor
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Devel/StackTrace.pm) perl(ExtUtils/MakeMaker.pm) perl(Glib/Ex/SignalIds.pm) perl(Glib/Object/Subclass.pm) perl(Gnome2/Canvas.pm) perl(Goo/Canvas.pm) perl(Gtk2.pm) perl(Gtk2/Ex/Dragger.pm) perl(Gtk2/Ex/GdkBits.pm) perl(Gtk2/Ex/KeySnooper.pm) perl(Gtk2/Ex/SyncCall.pm) perl(Gtk2/Ex/TickerView.pm) perl(Gtk2/Ex/WidgetBits.pm) perl(Gtk2/Ex/WidgetCursor.pm) perl(Gtk2/Ex/WidgetEvents.pm) perl(HTML/Entities.pm) perl(Locale/Messages.pm) perl(Math/Complex.pm) perl(Math/Trig.pm) perl(Pod/Simple/HTML.pm) perl(Scalar/Util.pm) perl(Smart/Comments.pm) perl(Tie/RefHash/Weak.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 23
Release: alt2
Summary: Helpers for Gtk2 widgets.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/gtk2-ex-xor/index.html

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KR/KRYDE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is support code shared by `Gtk2::Ex::CrossHair' and
`Gtk2::Ex::Lasso'.

Both those add-ons draw using an "xor" onto the pixels in a widget (hence
the dist name), using a value that flips between the widget background and
the cross or lasso line colour.  Drawing like this is fast and portable,
though doing it as an add-on can potentially clash with what the widget does
natively.

=over 4

=item *

A single dominant background colour is assumed.  Often shades of grey or
similar will end up with a contrasting line but there's no guarantee of
that.

=item *

The background colour is taken from the widget `Gtk2::Style' "bg" for
normal widgets, or from "base" for text widgets `Gtk2::Entry' and
`Gtk2::TextView'.  `Goo::Canvas' is recognised as using "base" too.

=item *

Expose events are watched and xoring redone, though it assumes the widget
will redraw only the exposed region, as opposed to a full window redraw.
Clipping in a redraw is usually what you want, especially if the display
might not have the X double-buffering extension.

=item *

For multi-window widgets it's necessary to figure out which subwindow is the
one to draw on.  The xoring recognises the "bin" window of `Gtk2::Layout'
(which includes `Gnome2::Canvas'), the "text" subwindow of
`Gtk2::TextView', and the secret subwindows of `Gtk2::Entry' and
`Goo::Canvas'.

=item *

The SyncCall mechanism is used to protect against flooding the server with
more drawing than it can keep up with.  Each motion event would only result
in a few drawing requests, but it's still easy to overload the server if it
sends a lot of motions or if it's not very fast at drawing wide lines.  The
effect of SyncCall is to delay further drawing until hearing back from the
server that the previous has completed.

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING Changes README examples
%perl_vendor_privlib/G*

%changelog
