Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: /usr/bin/xvfb-run perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global use_x11_tests 1

Name:           perl-Gtk2-Notify
Version:        0.05
Release:        alt13_52
Summary:        Perl interface to libnotify
License:        LGPLv2+
URL:            https://metacpan.org/release/Gtk2-Notify
Source0:        https://cpan.metacpan.org/authors/id/F/FL/FLORA/Gtk2-Notify-%{version}.tar.gz
Patch0:         libnotify.patch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
# gtk2-devel needed for <gtk2perl.h> from perl-Gtk2
BuildRequires:  gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel
BuildRequires:  libnotify-devel libnotify-gir-devel
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(base.pm)
BuildRequires:  perl(ExtUtils/Depends.pm)
BuildRequires:  perl(ExtUtils/PkgConfig.pm)
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(Glib/MakeHelper.pm)
BuildRequires:  perl(Gtk2/CodeGen.pm)
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(DynaLoader.pm)
BuildRequires:  perl(Gtk2.pm)
# Tests:
BuildRequires:  perl(Glib.pm)
BuildRequires:  perl(Gtk2/TestHelper.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
# Optional tests:
BuildRequires:  perl(Test/Pod.pm)
%if %{use_x11_tests}
# X11 tests:
# Some tests invoke glib functions which try dbus-launch. Without
# dbus-launch, an warning is emmitted which causes Test::Exception to raise an
# error.
BuildRequires:  dbus-tools-gui
# And the dbus is used to talk to org.freedesktop.Notifications server which
# can be requested by desktop-notification-daemon RPM symbol. However it can
# pull whole Gnome or KDE. So we use mimalistic `dunst' instead.
BuildRequires:  dunst
BuildRequires:  fontlang(en)
BuildRequires:  xorg-xvfb xvfb-run
BuildRequires:  xinit
%endif
Requires:       perl(Carp.pm)
Source44: import.info

%description
Perl bindings to libnotify.  This module will allow one to use the notify
functionality from within a perl application.

%prep
%setup -q -n Gtk2-Notify-%{version}
%patch0 -p1
# Remove bundled module
rm -r ./inc/*
sed -i -e '/^inc\//d' MANIFEST

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 OPTIMIZE="%{optflags}"
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name '*.bs' -size 0 -delete
# %{_fixperms} %{buildroot}/*

%check
# tests mostly bomb under mock, unfortunately
%if %{use_x11_tests}
xvfb-run -a make test
%else
make test
%endif

%files
%doc Changes examples README
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/Gtk2*

%changelog
