# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Gtk2.pm) perl(Test/More.pm) xvfb-run
# END SourceDeps(oneline)
%ifndef _build_display
%def_without test
%endif
%define module_version 0.1.2
%define module_name Gtk2-PathButtonBar
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.2
Release: alt1
Summary: Creates a bar for path manipulation.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/V/VV/VVELOX/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This creates a collection of buttons and a entry widget to help with browsing a
path or etc.

It is composed of two lines. The first line contains a set of buttons. The first button
is a button that blanks the current path. This is the 'goRoot' button and displays what ever
the user has decided the root is by setting the 'root' key when invoking the new funtions.
The buttons after that are ones that correspond to a chunk of the path, broken up by what ever
the delimiter is set to. When any of these are pressed, the entry text is changed as well to
relfect it. The 'goRoot' button clears the path to ''.

The second line starts with a label. The label is the same as on the 'goRoot' button and is
what ever the root is set as. After that there is a single line text entry widget. This allows
the path to be set by typing it in. After the text entry widget, there is a button labeled 'Go'.
When this button is pressed, it updates the button bar with what is in text entry widget.

Any time the path is updated, '$self->{exec}' is ran through eval.

    use Gtk2;
    use Gtk2::PathButtonBar;
    
    Gtk2->init;
    
    my $window = Gtk2::Window->new();
    
    my $pbb=Gtk2::PathButtonBar->new({exec=>'print "path=".${$myself}->{path}."\na=".${$myself}->{vars}{a}."\n";',
                                    vars=>{a=>1},
                                    });
    
    print $pbb->{vbox}."\n";
    
    $window->add($pbb->{vbox});
    
    $window->show;


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build
xvfb-run -a make test

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/G*

%changelog
