# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Test2/Tools/Tiny.pm)
# END SourceDeps(oneline)
%define module_name H
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Method wrappers for hash construction.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EX/EXODIST/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
It is nice to make hashes like this:

    {
        foo => $thing1->foo(),
        bar => $thing2->bar(),
    }

Note that our hash keys and method names match, this is a common situation.

There are many pitfalls, `$thing1->foo()' may return a scalar, an empty list, an
uneven list, or may return one thing in scalar context, and another in list
context. Sometimes you do not want the key to exist if `$thing1->foo'
returns an empty list.

To compensate you often must use one of these:

    { foo => scalar($bar->foo) }
    { foo => $bar->foo // undef }

    my $foo = $bar->foo;
    { defined($foo) ? (foo => $foo) : () }

    { foo => [$bar->foo] }
    { foo => {$bar->foo} }

This module makes it trivial to concisely make your expections, desires, and
reality all align.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE README.md Changes
%perl_vendor_privlib/H*

%changelog
