%define module_name HEAT-Crypto
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(CryptX.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt2
Summary: HEAT cryptographic routines
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TM/TMM/%{module_name}-%{version}.tar.gz

%description
This module provides HEAT compatible ECDH key agreement, signing and
message encryption ported to perl from the HEAT SDK.

The functions provided below need to be imported explicitly.

=over 4

=item keygen()

=item keygen( $seed_key );

Generates a new key pair. It returns a hash with 3 values:

  {
    p => <public key bytes>,
    k => <private key bytes>,
    s => <signing key bytes>,
  }

=item shared_key( $private_key, $public_key );

Computes shared secret.

Returns the key bytes.

=item sign( $private_key, $message );

Sign message with the private key.

Returns the signature bytes.

=item verify( $signature, $message, $public_key );

Verifies the message signature against the public key.

Returns 1 on success.

=item encrypt( $data, $key );

Encrypts data with the given key.

In array context it returns the encryption nonce, initialization vector and
cypher text. In scalar context it concatenates them.

=item decrypt( $data, $key );

Decrypts data with the given key. Data is expected to be in the format returned
by encrypt();

It returns the decrypted data on success or undefined in case of failure.

=item priv_to_pub_key( $private_key )

Derives the public key from the private key.

=item account_id( $public_key )

Derives the account ID from the public key.

=item keyspec( $key )

=item keyspec( $key, $is_private )

Parses the key specification into a 32 bytes buffer. A key can be specified as
a 64 characters hexadecimal string and a private key can be specified as a
secret phrase. All functions accepting key parameters use this functions to
read them.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md
%perl_vendor_archlib/H*
%perl_vendor_autolib/*

%changelog
