%define module_version 0.072
%define module_name HOI-Match
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Parse/Lex.pm) perl(Parse/Yapp/Driver.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.072
Release: alt1
Summary: Higher-Order Imperative "Re"features in Perl
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/W/WI/WITHERING/HOIMatch-0072/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
HOI::Match offers Erlang-like pattern matching in function parameters. 
Currently only wildcard symbols, lists and algebraic-data-type like hashrefs
are supported.

A wildcard symbol ([A-Za-z_][A-Za-z0-9_]*) matches exactly one argument.
A list is represented as an array reference. 
An algebraic-data-typed object is represented as an hashref with two keys,
namely "type", which gives its typename, and "val", which is an array reference 
containing zero or more wildcard symbols, lists, or algebraic-data-typed objects.

The BNF used to define the pattern grammar is given below:


Types: Type 
     | Type COMMA Types 


Type: CONST
    | IDENT 
    | Type CONCAT Type 
    | NIL 
    | IDENT LPAREN Typelist RPAREN 


Typelist: <eps>
        | Type Typelist 


where

CONST = (?:0(?:\.[0-9]+)?)|(?:[1-9][0-9]*(?:\.[0-9]+)?)|(?:\".+\")|(?:\'.+\')

IDENT = [A-Za-z_][A-Za-z0-9_]*

CONCAT = ::

NIL = nil

LPAREN = (

RPAREN = )

COMMA = ,

are tokens.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/H*

%changelog
