%define module_name HTML-Blitz
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cpanel/JSON/XS.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FindBin.pm) perl(Function/Parameters.pm) perl(HTML/Entities.pm) perl(HTML/Template.pm) perl(HTML/Template/Pro.pm) perl(HTML/Zoom.pm) perl(List/Util.pm) perl(Mojo/Template.pm) perl(Mojolicious.pm) perl(Scalar/Util.pm) perl(Sereal/Decoder.pm) perl(Sereal/Encoder.pm) perl(Template.pm) perl(Test2/API.pm) perl(Test2/V0.pm) perl(Text/Xslate.pm) perl(constant.pm) perl(feature.pm) perl(overload.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0901
Release: alt1
Summary: high-performance, selector-based, content-aware HTML template engine
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MAUKE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
HTML::Blitz is a high-performance, CSS-selector-based, content-aware template
engine for HTML5. Let's unpack that:

=over

=item *

You want to generate web pages. Those are written in HTML5.

=item *

Your HTML documents are mostly static in nature, but some parts need to be
filled in dynamically (often with data obtained from a database query). This is
where a template engine shines.

(On the other hand, if you prefer to generate your HTML completely dynamically
with ad-hoc code, but you still want to be safe from HTML injection and XSS
vulnerabilities, have a look at the HTML::Blitz::Builder manpage.)

=item *

Most template systems are content agnostic: They can be used for pretty much
any format or language as long as it is textual.

HTML::Blitz is different. It is restricted to HTML, but that also means it
understands more about the documents it processes, which eliminates certain
classes of bugs. (For example, HTML::Blitz will never produce mismatched tags
or forget to properly encode HTML entities.)

=item *

The format for HTML::Blitz template files is plain HTML. Instead of embedding
special template directives in the source document (like with most other
template systems), you write a separate piece of Perl code that instructs
HTML::Blitz to fill in or repeat elements of the source document. Those
elements are targeted with CSS selectors.

=item *

Having written the HTML document template and the corresponding processing
rules (consisting of CSS selectors and actions to be applied to matching
elements), you then compile them together into an the HTML::Blitz::Template manpage
object. This object provides functions that take a set of input values, insert
them into the document template, and return the finished HTML page.

This latter step is quite fast. See the PERFORMANCE entry elsewhere in this document for details.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README COPYING
%perl_vendor_privlib/H*

%changelog
