%define module_version 0.105
%define module_name HTML-HTML5-Sanity
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Locale/Country.pm) perl(Test/More.pm) perl(XML/LibXML.pm) perl(XML/LibXML/Debugging.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.105
Release: alt1
Summary: make HTML5 DOM trees less insane
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/HTML-HTML5-Sanity

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The Document Object Model (DOM) generated by HTML::HTML5::Parser meets
the requirements of the HTML5 spec, but will probably catch a lot of
people by surprise.

The main oddity is that elements and attributes which appear to be
namespaced are not really. For example, the following element:

  <div xml:lang="fr">...</div>

Looks like it should be parsed so that it has an attribute "lang" in
the XML namespace. Not so. It will really be parsed as having the
attribute "xml:lang" in the null namespace.

=over 4

=item `fix_document($document)'

  $sane_dom = fix_document($html5_dom);

Returns a modified copy of the DOM and leaving the original DOM
unmodified.

=item `fix_element($element_node, $new_document_node, \%%namespaces)'

Don't use this. Not exported.

=item `fix_attribute($attribute_node, $new_element_node, \%%namespaces)'

Don't use this. Not exported.

=item `$HTML::HTML5::Sanity::FIX_LANG_ATTRIBUTES'

  $HTML::HTML5::Sanity::FIX_LANG_ATTRIBUTES = 2;
  $sane_dom = fix_document($html5_dom);

If set to 1 (the default), the package will detect invalid values in
@lang and @xml:lang, and remove the attribute if it is invalid. If set
to 2, it will also attempt to canonicalise the value (e.g. 'EN_GB' will
be converted to to 'en-GB'). If set to 0, then the value of language
attributes is not checked.

=back


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes COPYRIGHT README LICENSE
%perl_vendor_privlib/H*

%changelog
