%define module_name HTML-Index
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(BerkeleyDB.pm) perl(Carp.pm) perl(Carp/Assert.pm) perl(Class/Struct.pm) perl(Compress/Zlib.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Path.pm) perl(HTML/Entities.pm) perl(HTML/TreeBuilder.pm) perl(Lingua/Stem.pm) perl(Text/Soundex.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.19
Release: alt1
Summary: Perl modules for creating and searching an index of HTML files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AW/AWRIGLEY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
HTML::Index is a set of modules for creating an index of HTML documents so that
they can be subsequently searched by keywords, or by Boolean combinations of
keywords. It was originally inspired by indexer.pl script in the O'Reilly "CGI
Programming with Perl, 2nd Edition" book
(http://www.oreilly.com/catalog/cgi2/author.html).

All storage operations are contained in the HTML::Index::Store module that can
be subclassed to support other storage options (such as BerkeleyDB files, or
SQL databases). Two such subclasses (HTML::Index::Store::BerkeleyBD and
HTML::Index::DataDumper) are included in the distribution.

The modules can be used to index any HTML documents - whether stored as files,
or in a database. They support the use of stopword lists, soundex searches,
compression of the inverted indexes and re-indexing of documents. Search
queries can be expressed as compound Boolean expressions, composed of keywords,
parentheses, and logical operators (OR, AND, NOT).


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/H*

%changelog
