# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 1.30
%define module_name HTML-Macro
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.30
Release: alt1
Summary: process HTML templates with loops, conditionals, macros and more!
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SO/SOKOLOV/%module_name-%module_version.tgz
BuildArch: noarch

%description
HTML::Macro is a module to be used behind a web server (in CGI scripts). It
provides a convenient mechanism for generating HTML pages by combining
"dynamic" data derived from a database or other computation with HTML
templates that represent fixed or "static" content of a page.

There are many different ways to accomplish what HTML::Macro does,
including ASP, embedded perl, CFML, etc, etc. The motivation behind
HTML::Macro is to keep everything that a graphic designer wants to play
with *in a single HTML template*, and to keep as much as possible of what a
perl programmer wants to play with *in a perl file*.  Our thinking is that
there are two basically dissimilar tasks involved in producing a dynamic
web page: graphic design and programming. Even if one person is responsible
for both tasks, it is useful to separate them in order to aid clear
thinking and organized work.  I guess you could say the main motivation for
this separation is to make it easier for emacs (and other text processors,
including humans) to parse your files: it's yucky to have a lot of HTML in
a string in your perl file, and it's yucky to have perl embedded in a
special tag in an HTML file.

HTML::Macro began with some simple programming constructs: macro
expansions, include files, conditionals, loops and block quotes.  Since
then we've added very little: only a define tag to allow setting values and
an eval tag to allow perl function calls in a nested macro scope.  Our
creed is "less is more, more or less."

HTML::Macro variables will look familiar to C preprocessor users or
especially to Cold Fusion people.  They are always surrounded with single
or double hash marks: "#" or "##".  Variables surrounded by double hash
marks are subject to html entity encoding; variables with single hash marks
are substituted "as is" (like single quotes in perl or UNIX shells).
Conditionals are denoted by the <if> and <else> tags, and loops by the
<loop> tag.  Quoting used to be done using a <quote> tag, but we now
deprecate that in favor of the more familiar CFML quoting syntax: <!---
--->.


%prep
%setup -n %module_name

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO Changes README
%perl_vendor_privlib/H*
%perl_vendor_privlib/auto/*

%changelog
