# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(parent.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    HTML-SimpleLinkExtor
%define upstream_version 1.273

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    A simple way to extract links
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/HTML/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(AutoLoader.pm)
BuildRequires: perl(Carp.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec/Functions.pm)
BuildRequires: perl(HTML/LinkExtor.pm)
BuildRequires: perl(LWP/UserAgent.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Most.pm)
BuildRequires: perl(Test/Output.pm)
BuildRequires: perl(URI.pm)
BuildRequires: perl(URI/file.pm)
BuildArch:  noarch
Source44: import.info

%description
This is a simple HTML link extractor designed for the person who does not
want to deal with the intricacies of 'HTML::Parser' or the de-referencing
needed to get links out of 'HTML::LinkExtor'.

You can extract all the links or some of the links (based on the HTML tag
name or attribute name). If a <BASE HREF> tag is found, all of the relative
URLs will be resolved according to that reference.

This module is simply a subclass around 'HTML::LinkExtor', so it can only
parse what that module can handle. Invalid HTML or XHTML may cause
problems.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%{make}

%check
%{make} test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  examples
%{_bindir}/*
%{_mandir}/man1/*
%perl_vendor_privlib/*

%changelog
