%define module_name HTML-TagReader
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DynaLoader.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.13
Release: alt3
Summary: Perl extension module for reading html/sgml/xml files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GU/GUS/%{module_name}-%{version}.tar.gz
BuildRequires: perl(Image/Size.pm)

%description
The module implements a fast and small object oriented way of
processing any kind of html/sgml/xml files by tag.

The getbytoken(0) is similar to while(<>) but instead of reading lines 
it reads tags or tags and text. 

HTML::TagReader makes it easy to keep track of the line number in a file
even though you are not reading the file by line. This important if you
want to implement error messages about html errors in your code.

Here is a program that list all href tags
in a html file together with line numbers and column:

    use HTML::TagReader;
    my $p=new HTML::TagReader "file.html";
    my @tag;
    while(@tag = $p->gettag(1)){
            if ($tag[0]=~/ href ?=/i){
                    # remove optional space before the equal sign:
                    $tag[0]=~s/ ?= ?/=/g;
                    print "line: $tag[1]: col: $tag[2]: $tag[0]\n";
            }
    }

Here is a program that will read a html file tag
wise:

    use HTML::TagReader;
    my $p=new HTML::TagReader "file.html";
    my @tag;
    while(@tag = $p->getbytoken(1)){
            if ($tag[1] eq ""){
                    print "line: $tag[2]: col: $tag[2]: not a tag (some text), \"$tag[0]\"\n\n";
            }else{
                    print "line: $tag[2]: col: $tag[2]: is a tag, $tag[0]\n\n";
            }
    }

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release
BuildArch: noarch

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/H*
%perl_vendor_autolib/*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
