Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-HTML-Toc
Version:        1.12
Release:        alt2_42
Summary:        Generate, insert and update HTML Table of Contents
License:        GPL+ or Artistic

URL:            https://metacpan.org/release/HTML-Toc
Source0:        https://cpan.metacpan.org/authors/id/F/FV/FVULTO/HTML-Toc-%{version}.tar.gz
# don't skip man pages
Patch0:         man3pods.patch
Patch1:         HTML-Toc-1.12-Fix-unescaped-left-brace-in-regex.patch

BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(HTML/Entities.pm)
BuildRequires:  perl(HTML/Parser.pm)
BuildRequires:  perl(Roman.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test.pm)
BuildRequires:  perl(Test/Differences.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(vars.pm)
Requires:       perl(Roman.pm)


Source44: import.info
%filter_from_provides /^perl(HTML._.*.pm)/d

%description
Generate, insert and update HTML Table of Contents (ToC).

%prep
%setup -q -n HTML-Toc-%{version}
%patch0 -p 1
%patch1 -p 1
find . -type f | xargs chmod 0644

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes
%{perl_vendor_privlib}/HTML*

%changelog
