%define module_name HTTP-AnyUA
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(AnyEvent/HTTP.pm) perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Spec.pm) perl(Furl.pm) perl(Future.pm) perl(HTTP/Request.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(JSON.pm) perl(MIME/Base64.pm) perl(Module/Loader.pm) perl(Mojo/IOLoop.pm) perl(Net/Curl/Easy.pm) perl(Plack/Runner.pm) perl(Scalar/Util.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test2/API.pm) perl(Time/HiRes.pm) perl(Time/Local.pm) perl(bytes.pm) perl(lib.pm) perl(namespace/clean.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.904
Release: alt1
Summary: An HTTP user agent programming interface unification layer
Group: Development/Perl
License: perl
URL: https://github.com/chazmcgarvey/HTTP-AnyUA

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CC/CCM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a small wrapper for unifying the programming interfaces of several different
actual user agents (HTTP clients) under one familiar interface.

Rather than providing yet another programming interface for you to learn, HTTP::AnyUA follows the
the HTTP::Tiny manpage interface. This also means that you can plug in any supported HTTP client
(the LWP::UserAgent manpage, the Furl manpage, etc.) and use it as if it were the HTTP::Tiny manpage.

There are a lot of great HTTP clients available for Perl, each with different goals, different
feature sets, and of course different programming interfaces! If you're an end user, you can just
pick one of these clients according to the needs of your project (or personal preference). But if
you're writing a module that needs to interface with a web server (like perhaps a RESTful API
wrapper) and you want your users to be able to use whatever HTTP client they want, HTTP::AnyUA can
help you support that!

It's a good idea to let the end user pick whatever HTTP client they want to use, because they're the
one who knows the requirements of their application or script. If you're writing an event-driven
application, you'll need to use a non-blocking user agent like the Mojo::UserAgent manpage. If you're writing
a simple command-line script, you may decide that your priority is to minimize dependencies and so
may want to go with the HTTP::Tiny manpage.

Unfortunately, many modules on CPAN are hardcoded to work with specific HTTP clients, leaving the
end user unable to use the HTTP client that would be best for them. Although the end user won't --
or at least doesn't need to -- use HTTP::AnyUA directly, they will benefit from client choice if
their third-party modules use HTTP::AnyUA or something like it.

The primary goal of HTTP::AnyUA is to make it easy for module developers to write HTTP code once
that can work with any HTTP client the end user may decide to plug in. A secondary goal is to make
it easy for anyone to add support for new or yet-unsupported use...

%prep
%setup -q -n %{module_name}-%{version}
[ %version = 0.904 ] && rm -f t/50-future-subclass.t

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/H*

%changelog
